TITLE   'Cooling by Forced Convection'	 	                  { exa152.pde }
SELECT     						{ Student Version }
   errlim=1e-5     ngrid=1     spectral_colors	
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   temp
DEFINITIONS
   r1=10e-3     r2=50e-3     L=40e-3
   temp2=300     heat=0     k=55                       	{ Magnesium oxide }
   power_m=1e4     fluxd_in=power_m/(2*pi*r1)
   fluxd_r=-k*dr(temp)     fluxd_z=-k*dz(temp)
   fluxd=vector( fluxd_r, fluxd_z)     fluxdm=magnitude( fluxd)
EQUATIONS
   div( fluxd)=heat
BOUNDARIES
region 'domain' start(r1,0)  natural( temp)=0  line to (r2,0)
   natural(temp)=1e3*(temp- temp2)  line to (r2,L)
   natural(temp)=0  line to (r1,L)  to  (r1,L/2) mesh_spacing=0.2*r1
   natural(temp)=-fluxd_in   line to close
PLOTS
   contour( temp)     vector( fluxd) norm     contour( fluxdm) painted	
   contour( fluxd_r) painted     contour( fluxd_z) painted
END


